DROP PROCEDURE [hips].[DownloadedDocumentInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Credte date: 12 Oct 2012
-- Description:   Gets a specific record from the DocumentType Table
-- Modified:
-- 10/03/2013 - Simon Biber - changed current document ID to allow nulls
-- =============================================
CREatE PROCEDURE [hips].[DownloadedDocumentInsert] 
(
	@PatientMasterId INT,
	@SourceSystemDocumentId VARCHAR(256),
	@Package VARBINARY(MAX),
	@DownloadedDate DATETIME,
	@ClinicalDocumentStatusId INT,
	@CurrentDocumentId INT = NULL,
	@UserModified varchar(256)
	
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @DownloadedDocumentId int

    SET @intErrorCode = 0


	INSERT INTO hips.DownloadedDocument
	(
		PatientMasterId,
		SourceSystemDocumentId,
		Package,
		DownloadedDate,
		ClinicalDocumentStatusId,
		CurrentDocumentId,
		[DateCreated],
        [UserCreated],
        [DateModified],
        [UserModified]
		)
VALUES
	(
	@PatientMasterId
	, @SourceSystemDocumentId
	, @Package
	, @DownloadedDate
	, @ClinicalDocumentStatusId
	, @CurrentDocumentId
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	SELECT @intErrorCode = @@ERROR , @DownloadedDocumentId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [DownloadedDocumentId],
				[PatientMasterId],
                [SourceSystemDocumentId],
                [Package],
                [DownloadedDate],
                [ClinicalDocumentStatusId],
                [CurrentDocumentId],
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[DownloadedDocument]
         WHERE [DownloadedDocumentId] = @DownloadedDocumentId
    END

    RETURN(@intErrorCode)

END
GO

